<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

class CouponFactory extends Factory
{
    public function definition(): array
    {
        return [
            'code'                => $this->faker->unique()->word,
            'discount_percentage' => $this->faker->numberBetween(1, 100),
            'max_uses'            => $this->faker->numberBetween(1, 100),
            'uses'                => $this->faker->numberBetween(0, 100),
            'start_date'          => $this->faker->dateTimeBetween('now', '+1 month'),
            'end_date'            => $this->faker->dateTimeBetween('+1 month', '+2 months'),
            'status'              => $this->faker->boolean,
            'created_at'          => now(),
            'updated_at'          => now(),
        ];
    }
}
