<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

    /**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\FreeMaterial>
 */
class FreeMaterialFactory extends Factory
{
        /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $type = $this->faker->randomElement(['video', 'pdf']);
        if($type == 'video'){
            $link = 'https://youtu.be/ZZHVKw-djZ0?si=3rkBQqbyKl1fBms1';
        }elseif($type == 'pdf'){
            $link = 'https://www.ulethbridge.ca/sites/default/files/docs/LearningPlanSample.pdf';
        }
        return [
            'type'  => $type,
            'title' => $this->faker->sentence,
            'link'  => $link,
        ];
    }
}
