<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Round;
use App\Enums\UserType;
use App\Models\Lecture;
use App\Enums\FeedbackType;
use App\Models\RoundStudent;
use Illuminate\Database\Eloquent\Factories\Factory;

class TaskSubmissionFactory extends Factory
{
    public function definition(): array
    {
        $roundStudentIds = RoundStudent::pluck('user_id');
        $roundIds = RoundStudent::pluck('round_id');
        $lecturesIds = Lecture::whereIn('round_id', $roundIds)->pluck('id');
        $usersIds = User::whereIn('id', $roundStudentIds)->pluck('id');
        $instructorsIds   = User::where('type', UserType::INSTRUCTOR->value)->pluck('id');
        return [
            'task_url'      => $this->faker->url,
            'feedback'      => $this->faker->paragraph,
            'is_corrected'  => $this->faker->boolean,
            'task_degree'   => $this->faker->numberBetween(1, 10),
            'graded_by'     => $this->faker->randomElement($instructorsIds),
            'feedback_type' => $this->faker->randomElement(FeedbackType::values()),
            'user_id'       => $this->faker->randomElement($usersIds),
            'lecture_id'    => $this->faker->randomElement($lecturesIds),
        ];
    }
}
