<?php

use App\Enums\DefineStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('rounds', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_id')->constrained('courses')->onDelete('restrict');
            $table->foreignId('instructor_id')->nullable()->constrained('users')->onDelete('restrict');
            $table->string('name')->index();
            $table->date('start_date');
            $table->date('end_date');
            $table->decimal('discount', 5, 2)->default(0.00)->nullable();
            $table->unsignedInteger('students_count')->default(0);
            $table->string('whatsapp_group_link')->nullable();
            $table->unsignedTinyInteger('status')->default(DefineStatus::default())->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('rounds');
    }
};
