<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('transaction_id')->unique();
            $table->bigInteger('order_id');
            $table->integer('amount');
            $table->string('currency', 5)->default('EGP');
            $table->boolean('success')->default(false);
            $table->timestamp('transaction_created_at')->nullable();
            $table->boolean('is_3d_secure')->default(false);
            $table->string('payment_method')->nullable();
            $table->string('card_type')->nullable();
            $table->string('card_last4', 4)->nullable();
            $table->string('receipt_number')->nullable();
            $table->string('customer_email')->nullable();
            $table->string('customer_phone')->nullable();
            $table->json('items')->nullable();
            $table->string('payment_for')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
