<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('round_students', function (Blueprint $table) {
            $table->decimal('total_amount', 10, 2)->nullable();
            $table->date('enrollment_date')->nullable();
            $table->string('status')->nullable();
            $table->string('payment_method')->nullable();
            $table->string('payment_status')->nullable();
            $table->string('transaction_id')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('round_students', function (Blueprint $table) {
            $table->dropColumn('total_amount');
            $table->dropColumn('enrollment_date');
            $table->dropColumn('status');
            $table->dropColumn('payment_method');
            $table->dropColumn('payment_status');
            $table->dropColumn('transaction_id');
        });
    }
};
