<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('lecture_questions', function (Blueprint $table) {
            $table->id();
            $table->foreignId(column: 'lecture_id')->constrained(table: 'lectures')->onDelete('cascade');
            $table->unsignedTinyInteger(column: 'category');
            $table->unsignedTinyInteger(column: 'question_type');
            $table->string(column: 'question_content');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('lecture_questions');
    }
};
