<?php

use App\Enums\PaymentMethodEnum;
use App\Enums\PaymentTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('course_enrollment_id')->nullable()->constrained('course_enrollments');
            $table->foreignId('installment_id')->nullable()->constrained('installments');
            $table->decimal('amount', 10, 2);
            $table->integer('payment_method')->default(PaymentMethodEnum::CASH->value);
            $table->integer('type')->default(PaymentTypeEnum::CASH->value);
            $table->date('payment_date');
            $table->text('notes')->nullable();
            $table->foreignId('accepted_by')->nullable()->constrained('users');
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('updated_by')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
