<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->timestamp('last_activity')->nullable();
            $table->boolean('is_open')->default(false)->after('last_activity');
            $table->timestamp('last_logout_at')->nullable()->after('is_open');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['last_activity', 'is_open', 'last_logout_at']);
        });
    }
};
