<?php

namespace Database\Seeders;

use App\Models\User;
use App\Enums\UserType;
use App\Enums\UserStatus;
use Illuminate\Database\Seeder;

class InstructorSeeder extends Seeder
{
            /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run(): void
    {      
        $instructors = [
            [
                'name'          => 'Instructor 1',
                'email'         => 'instructor1@example.com',
                'password'      => bcrypt('password'),
                'type'          => UserType::INSTRUCTOR,
                'phone'         => '1234567890',
            ],  
            [
                'name'          => 'Instructor 2',
                'email'         => 'instructor2@example.com',
                'password'      => bcrypt('password'),
                'type'          => UserType::INSTRUCTOR,
                'phone'         => '1234567890',
            ],
        ];
        
        User::insert($instructors);
    }
}
