<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Question;
use App\Models\BankOption;
use App\Models\Category;
use App\Models\PlacementTestTag;

class QuestionSeeder extends Seeder
{
    public function run(): void
    {
        $categories = Category::pluck('id')->toArray();
        $tags = PlacementTestTag::pluck('id')->toArray();
        $questionTypes = [0, 1];

        foreach (range(1, 50) as $i) {
            $type = $questionTypes[array_rand($questionTypes)];

            $question = Question::create([
                'category_id'       => $categories[array_rand($categories)],
                'tag_id'            => $tags[array_rand($tags)],
                'question_type'     => $type,
                'listening_content' => $type === 0
                    ? 'lecture-questions/4766520250530021556mixkit-crickets-and-insects-in-the-wild-ambience-39.wav'
                    : null,
                'question_content'  => "Question $i content",
            ]);

            $correct = rand(0, 2);
            foreach (range(0, 2) as $j) {
                BankOption::create([
                    'question_id'    => $question->id,
                    'option_content' => "Option $j for Q$i",
                    'is_correct'     => $j === $correct ? 1 : 0,
                ]);
            }
        }
    }
}
