<?php

namespace Database\Seeders;

use App\Models\Lecture;
use App\Models\Review;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ReviewSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $users=User::all();
        $lectures=Lecture::all();
        foreach($users as $user){
            foreach($lectures as $lecture){
                Review::create([
                    'user_id' => $user->id,
                    'lecture_id' => $lecture->id,
                    'rating'=>rand(1,5),
                    'comment'=>'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua'
                    ]);
            }
        }
    }
}
