<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $permissions=[
            'role-list',
            'role-create',
            'role-edit',
            'role-delete',
        ];

        foreach($permissions as $permission){
            Permission::create(['name' => $permission]);
        }

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        $role = Role::create(['name' => 'super-admin']);
        $role->givePermissionTo(Permission::all());
        User::where('email','admin@admin.com')->first()->assignRole($role);
    }
}
