<?php

namespace Database\Seeders;

use App\Models\Setting;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            [
                'key' => 'logo',
                'value' => '',
                'category' => 'logos',
                'type' => 'image',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'facebook',
                'value' => 'https://test-facebook-link',
                'category' => 'social links',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'x',
                'value' => 'https://test-x-link',
                'category' => 'social links',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'linkedin',
                'value' => 'https://test-linkedin-link',
                'category' => 'social links',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'phone_1',
                'value' => '+123456789',
                'category' => 'contact',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'phone_2',
                'value' => '+987654321',
                'category' => 'contact',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'whatsapp_num_1',
                'value' => '+987654321',
                'category' => 'whatsapp',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'whatsapp_num_2',
                'value' => '+987654321',
                'category' => 'whatsapp',
                'type' => 'string',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'about',
                'value' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit...',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'help_center',
                'value' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit...',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'terms_and_conditions',
                'value' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit...',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'about_ar',
                'value' => 'عن المنصه الالكترونيه لوريم ايبسوم',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'help_center_ar',
                'value' => 'المساعدة الالكترونيه لوريم ايبسوم',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'terms_and_conditions_ar',
                'value' => 'الشروط والاحكام الالكترونيه لوريم ايبسوم',
                'category' => 'pages',
                'type' => 'textarea',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($settings as $setting) {
            Setting::create($setting);
        }
    }
}
